# Neue Vertragsklausel

Um <a
href="#!/guide/pD9B63C45_48A0_4A0C_8FBD_B8BAB435312F">Vertragsklauseln</a> in Dokumenten verwenden zu können, müssen zunächst neue Klauseln im System hinterlegt werden. Dies ist über die Aktion &quot;Neue Vertragsklausel&quot; möglich.

## Aktion: Neue Vertragsklausel

Die Aktion kann im Reiter `Neu` der Multifunktionsleiste aufgerufen werden.

{@img img1.png}

Außerdem wird zusätzlich die Kachel <span
style='font-weight:bold'>Neue Vertragsklausel </span>angeboten.

{@img img3.png}

### Vorbedingungen

*   Vertragsklauseln dürfen <span
style='font-weight:bold'>kontextlos</span> angelegt werden.
*   <span
style='font-weight:bold'>Klauselvorlage</span> auswählen (nur falls mehrere Vorlagen vorhanden).

### Dateneingabe

Für die Dateneingabe wird die Formular-Tab-Gruppe <span
style='font-weight:bold;font-style:italic'>002_contract_clause_create</span> des Formulars <span
style='font-weight:bold;font-style:italic'>sol_contract_clause</span> eingesetzt.

{@img img5.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Klauseldaten</span></td></tr></thead><tbody><tr><td>210_clause_base</td></tr><tr><td>220_clause_categories_toggle</td></tr><tr><td>221_clause_categories</td></tr><tr><td>230_clause_type_toggle</td></tr><tr><td>231_clause_type</td></tr></tbody></table>

<span class="tag_important">Die Auswahl der Vertragskategorien und -typen ist als Filtereinstellung zu verstehen. Die Klausel wird lediglich in Vertragsdokumenten zur Verfügung stehen, die entsprechende Filtervorgaben erfüllen. Im Standard sind beide Filter auf &quot;alle&quot; voreingestellt.</span>

Anschließend wird ein Word-Dokument geöffnet, in dem die Vertragsklausel festgehalten werden kann.

### Implementierung

<span class="tag_warning"><span
style='font-weight:bold'>Action definitions:</span> Definitionen der Aktion für die Clients finden sich in der Konfiguration `sol.contract.CreateClause`.</span>

Der <span
style='font-weight:bold'>technische Ablauf</span> wird durch eine konfigurierbare Aktion implementiert. Diese klont ein neues Element auf Basis der ausgewählten Klauselvorlage in der Chaosablage und startet den Workflow `sol.contract.contract.document.clause.create`.

Im Erfolgsfall werden folgende Events an den Client übermittelt:

<table><thead><tr><td>Event</td><td>Beschreibung</td><td>Status</td></tr></thead><tbody><tr><td>DIALOG</td><td>Zeigt das Formular zur Dateneingabe in einem Dialog an.</td><td></td></tr><tr><td>GOTO</td><td>Zeigt das neu angelegte Element im Client an.</td><td>CHECKOUT</td></tr></tbody></table>

<span
style='font-weight:bold'>Beschreibung des Workflows</span>

{@img img7.png}

<table><thead><tr><td><span
style='font-weight:bold'>Knotenbezeichnung</span></td><td><span
style='font-weight:bold'>Beschreibung</span></td><td><span
style='font-weight:bold'>Funktion</span></td></tr></thead><tbody><tr><td><span
style='font-weight:bold'>Data entry</span></td><td>Legt eine neue Vertragsklausel durch den Eigentümer an</td><td></td></tr><tr><td><span
style='font-weight:bold'>GENERATOR: Clause ID</span></td><td>Erzeugt eine interne Klauselnummer</td><td>sol.contract.ix.functions.generators.GenerateClauseId</td></tr><tr><td><span
style='font-weight:bold'>MOVE: Clause</span></td><td>Verschiebt das Klausel-SORD in das vorgesehene Verzeichnis</td><td>sol.common.ix.functions.Move</td></tr><tr><td><span
style='font-weight:bold'>FEED: clause created</span></td><td>Legt einen Feed-Eintrag zum Anlegen der Klausel an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>DELETE: temporary record</span></td><td>Löscht das SORD Objekt aus der Chaosablage</td><td>sol.common.ix.functions.Delete</td></tr></tbody></table>
